﻿using Inet.Viewer.Data;
using Inet.Viewer.Data;
using Inet.Viewer.test.WinForms;
using Inet.Viewer.WinForms;
using NUnit.Framework;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading;
using System.Windows.Forms;


namespace Inet.Viewer.WinForms
{
    /// <summary>
    /// Additional partial class for ReportPageView to provide access of private members during tests.
    /// </summary>
    internal partial class ReportContentView
    {
        public void SelectAreaPublic(Rectangle rectangle)
        {
            SelectArea(rectangle);
        }
    }
    internal class MyReportContentView : ReportContentView
    {
        private Exception ex;

        public override void ShowError(Exception ex)
        {
            Console.WriteLine(ex);
            this.ex = ex;
        }

        public void RethrowAnyException()
        {
            if (ex != null)
            {
                PreserveStackTrace(ex);
                throw ex;
            }
        }

        protected override void HandlePageRendered(object sender, EventArgs e)
        {
            base.HandlePageRendered(sender, e);
            lock (this)
            {
                Monitor.PulseAll(this);
            }
        }

        internal void WaitForRenderedPage()
        {
            WinFormsMessageLoop.Activate(this);
            Console.WriteLine("WaitForRenderedPage...");
            lock (this)
            {
                Monitor.Wait(this);
            }
            Console.WriteLine("WaitForRenderedPage done!");
        }

        static void PreserveStackTrace(Exception e)
        {
            var ctx = new StreamingContext(StreamingContextStates.CrossAppDomain);
            var mgr = new ObjectManager(null, ctx);
            var si = new SerializationInfo(e.GetType(), new FormatterConverter());

            e.GetObjectData(si, ctx);
            mgr.RegisterObject(e, 1, si);
            mgr.DoFixups();
        }
    }

    internal class MyReportView : ReportViewShowError
    {
        internal MyReportContentView MyReportContentView { get; set; }
        internal override ReportContentView CreateContentView()
        {
            return MyReportContentView = new MyReportContentView();
        } 
    }

    partial class SearchPanel
    {
        public ListView ListViewResults {
            get {
                return listViewResults;
            }
        }
    }

    public class MySearchLoader: SearchLoader
    {
        object mutex = new object();

        public MySearchLoader(ISearchResultReceiver resultReceiver, IRenderData reportData, string phrase, int startPage, SearchOption flags):
            base(resultReceiver, reportData, phrase, startPage, flags)
        {
            
        }

        public override void Run()
        {
            base.Run();
            lock (mutex)
            {
                Monitor.PulseAll(mutex);
            }
        }

        public void WaitOnFinishedRun()
        {
            lock (mutex)
            {
                Monitor.Wait(mutex);
            }
        }
    }
}

namespace Inet.Viewer.test.WinForms
{
    [TestFixture]
    class TestReportContentView
    {
        [Test]
        public void TestTextSelection()
        {
            URLRenderData data = new URLRenderData("http://dell28:9000/?report=repo:test/DotNetViewerTextSelectionTest.rpt");

            MyReportView view = new MyReportView();
            view.ReportData = data;

            MyReportContentView reportContentView = view.MyReportContentView;
            WinFormsMessageLoop.Activate(view);

            reportContentView.WaitForRenderedPage();
            Size size = reportContentView.ImageSize;

            reportContentView.Invoke((MethodInvoker)delegate
            {
                reportContentView.SelectAreaPublic(new Rectangle(0, 0, size.Width, size.Height / 4));
            });

            Assert.AreEqual("oben", reportContentView.SelectedText);

            reportContentView.Invoke((MethodInvoker)delegate
            {
                reportContentView.SelectAreaPublic(new Rectangle(0, size.Height / 4, size.Width, size.Height / 2));
            });
            Assert.AreEqual("Dies ist ein Testreport für die\r\nTextselektion im\r\nDotNetViewer.", reportContentView.SelectedText);

            reportContentView.Invoke((MethodInvoker)delegate
            {
                reportContentView.SelectAreaPublic(new Rectangle(0, size.Height * 3 / 4, size.Width, size.Height / 4));
            });
            Assert.AreEqual("unten", reportContentView.SelectedText);
        }
        [Test]
        public void TestTextSearch()
        {
            URLRenderData data = new URLRenderData("http://dell28:9000/?report=repo:test/DotNetViewerTextSelectionTest.rpt");
            ReportViewer reportViewer = new ReportViewer();
            MyReportView view = new MyReportView();
            //WinFormsMessageLoop.Activate(view);

            view.ReportData = data;
            view.ReportViewer = reportViewer;

            reportViewer.AddReportView(view);
            reportViewer.CurrentReportView = view;


            SearchPanel searchPanel = new SearchPanel();
            searchPanel.ReportViewer = reportViewer;
            WinFormsMessageLoop.Activate(searchPanel);
            MySearchLoader searchLoader = new MySearchLoader(searchPanel, data, "test", 0, SearchOption.None);
            searchLoader.Run();
            Assert.AreEqual(1,  searchPanel.ListViewResults.Items.Count);

            MySearchLoader searchLoader2 = new MySearchLoader(searchPanel, data, "es", 0, SearchOption.None);
            searchLoader2.Run();

            Assert.AreEqual(3, searchPanel.ListViewResults.Items.Count);
        }
    }
}
